﻿require("rootpath")();
const express = require("express");
const app = express();
const bodyParser = require("body-parser");
const cookieParser = require("cookie-parser");
const cors = require("cors");
const errorHandler = require("./middleware/error-handler");
const authorize = require("./middleware/authorize");



//app.use(express.static('uploads'));
app.use(cors({
  origin: '*',
  credentials: true
}));
app.use('/uploads', authorize())
app.use('/uploads', express.static(__dirname + '/uploads'));

app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(cookieParser());

// allow cors requests from any origin and with credentials
/*
app.use(
  cors({
    origin: (origin, callback) => callback(null, true),
    credentials: true,
  })
);
*/
//app.use(cors());



// api routes
app.use("/accounts", require("./accounts/accounts.controller"));
app.use("/offres", require("./offres/offres.controller"));
app.use("/candidatures", require("./candidatures/candidatures.controller"));

// swagger docs route
app.use("/api-docs", require("./helpers/swagger"));

// global error handler
app.use(errorHandler);

// start server
const port =
  process.env.NODE_ENV === "production" ? process.env.PORT || 80 : 4040;
app.listen(port, () => console.log("Server listening on port " + port));
