const { DataTypes } = require("sequelize");

module.exports = model;

function model(sequelize) {
  const attributes = {
    created: {
      type: DataTypes.DATEONLY,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updated: { type: DataTypes.DATEONLY },
    status: { type: DataTypes.STRING, allowNull: true },
    title: { type: DataTypes.STRING, allowNull: false },
    publicationDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
    expirationDate: { type: DataTypes.DATEONLY, allowNull: true },
    nature: { type: DataTypes.STRING, allowNull: false },
    type_contrat: { type: DataTypes.STRING, allowNull: true },
    pays: { type: DataTypes.STRING, allowNull: true },
    wilaya: { type: DataTypes.STRING, allowNull: false },
    email_destinataire: { type: DataTypes.STRING, allowNull: true },
    jobTitle: { type: DataTypes.STRING, allowNull: false },
    jobDescription: { type: DataTypes.TEXT, allowNull: false },
    requiredProfile: { type: DataTypes.TEXT, allowNull: true },
    autre: { type: DataTypes.TEXT, allowNull: true },
    wp_id: { type: DataTypes.INTEGER, allowNull: false },
  };

  return sequelize.define("offre", attributes);
}
